function [idx] = synsubset(varargin)
%This function allows you to used the classified data from savpivots to
%generate subsets.  Example, from VGluT1 synapses to generate VGluT1 with
%Synaptopodin synapses.  This will be based on distance. Note: Currently as
%it stands, rcombined all directories can be handled ok...as far as I can
%tell...there is the issue with the potential duplication of the ordinals,
%but the current usage of it support the duplication without error in terms
%of both data accuracy and syntax, but if you want to do more fancy stuff
%with ordinals, then keep this in mind OK!...However, if you want to
%continue on to using subsetoverlap, it is recommended that you do not used
%rcombined data, because subsetoverlap uses oridnals in a more fancy way.
%Synatax:   [] = synsubset('dist',5,'dir1','c:\...','file1','syn.csv','dir2',..,'dir3',..)
%           or [] = synsubset('index',index,'dir2',..,'dir3',..)
%Input:     'dist' = the distance by which this new subclass is determined,
%               specifically, it is the distance of the selected channel
%               from the origin that is specified here.  Default = 1.
%               Although if your using 100nm pixels, you should really use
%               5, for a 1um synapse.
%           'dir1' = the directory the the selected channel, e.g., the
%                channel that is used to define the new subclass
%           'file1' = the file that contains the properties of the channel
%               that is generated by savpivots that will be used to define
%               the new subclass.
%           'index' = if the index is entered, then dist, dir1 and file1
%               not needed, in fact, they will be ignored, because they are
%               used to denovo generate an index, the index essentially,
%               points to where in the old class the new subclass resides.
%           'dir2' = the directory where the origin dataset from savpivots
%               resides, in most instances, will be same as dir1.
%           'file2' = the file that contains the vertices of the origin
%               pivots.
%           'dir3' = the directory where the origin dataset from savpivots
%               resides, in most instances, will be same as dir1.
%           'file3' = the file that contains the vertices of the termini
%               pivots.
%           'dirsav' = the directory where you want to save the new subclass
%               to.
%           note: if nothing is entered, you will be prompted to select
%           dir1, dir2, dir3,dirsav
%           'vert' = the vert parameter once entered puts thes function
%               into vertices mode, which means it will generated the index
%               by taking a set of vertices and look for it in a larger set
%               of vertices and then pull those shared vertices out and
%               place them in files.  This is used if you already have the
%               vertices for the subset, and want to use those vertices to
%               generate files for all others properties.  If you enter
%               anything into vert that is not a X by 3 array, it will
%               prompt you to open the vert file.  Vert supercedes index.
%           'prepost' = determine also whether the third point should be
%               closer to ori or termi.  supercedes everything.  Default =
%               [], or off, 0 = near ori, 1 = near termi.  NOTE: for
%               prepost to work you must enter all of dir and files.
%Output:    idx = the indexed used to specifiy the new subset

[idx,dir2,dirsav,ord] = parse(varargin);

%now lets process the directory
dir_info = dir(dir2);   %grab the file info from dir2
[aprop,avert,aflat,arotvert] = process_files(dir_info);     %now get the files we want to process

%initiate
acount = [];
aucount = [];

%go through the files apply the index and save to new directory
for i = 1:size(aprop,2) %process the property files
    prop_tmp = single(dlmread([dir2,filesep,aprop{i}],',',1,0));    %open the file
    prop_tmp = prop_tmp(idx,:);     %the few, the proud, the selected
    sav2csv(prop_tmp,[aprop{i}(1:end-4),'_',num2str(size(prop_tmp,1))],dirsav);    %save out
    %now lets output the prop summary files: Note: we are assuming that
    %colume two is the volume properties
    out = median(prop_tmp(:,2))+std(prop_tmp(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp(:,2)>out);        %find the outliers.
    prop_cache = prop_tmp;   %we now want the prop to match the vert output, so work on a temporary var instead
    prop_cache(x,:) = [];             %remove the outliers
    prop_cache(isnan(prop_cache(:,1)),:) = [];    %remove not a numbers
    sdata(1,:) = mean(prop_cache,1);
    sdata(2,:) = std(prop_cache,1);
    sdata(3,:) = size(prop_cache,1);
    sdata(4,:) = median(prop_cache,1);
    %create a cell array of file names to label the count files
    strmask = isstrprop(aprop{i},'punct');  %find the punctuations, we only want the last two
    strmask2 = aprop{i}=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(aprop{i},'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    a = 1;  %initiate
    b = 0;
    tmp = aprop{i}(y(end-a)+1:y(end-b)-1);    %create an array of the words
    while ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        b = b+1;
        if size(y,2)-a==0
            break
        end
        tmp = aprop{i}(y(end-a)+1:y(end-b)-1);    %create an array of the words
    end
    %now do the same for the front
    a = 0;
    tmp = aprop{i}(1:y(1+a)-1);
    while ~isempty(str2num(tmp))&&size(y,2)~=a+1   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        tmp = aprop{i}(1:y(1+a)-1);    %create an array of the words
    end
    if a==0
        celllabels{i} = aprop{i}(y(1)+1:y(end-b)-1);
    else
        celllabels{i} = aprop{i}(y(a)+1:y(end-b)-1);
    end
    sav2csv(sdata,['asum_',celllabels{i}],dirsav);     %save the properties summary
end
for j = 1:size(avert,2) %process the vertices files
    vert_tmp = single(dlmread([dir2,filesep,avert{j}],',',1,0));    %open the file
    vert_tmp = vert_tmp(idx,:);     %the few, the proud, the selected
    if isempty(ord)&&size(vert_tmp,2)>3     %if no ordinals are set yet, set the ord, when at origin file
        ord = vert_tmp(:,end);      %grabbed
    end
    sav2csv(vert_tmp,[avert{j}(1:end-4),'_',num2str(size(vert_tmp,1))],dirsav);    %save out
    %lets generate the count statistic files
    acount = [acount size(vert_tmp,1)];    %do the same for the all data
    aucount = [aucount size(unique(vert_tmp,'rows'),1)];   %get the unique count from all data
end
%now process the rotations
for k = 1:size(aflat,2) %process the flat files
    try %just in case of empty files
        flat_tmp = single(dlmread([dir2,filesep,aflat{k}],',',1,0));    %open the file
        flat_idx = zeros(size(flat_tmp,1),1);   %create the index base
        for m = 1:size(ord,1)   %go through the ordinals
            flat_idx(flat_tmp(:,end)==ord(m,1),:) = 1;      %set to keep
        end
        flat_tmp = flat_tmp(logical(flat_idx),:);     %the few, the proud, the selected
        sav2csv(flat_tmp,aflat{k}(1:end-4),dirsav);    %save out
    catch
        warning([dirsav,filesep,'flat']);
    end
end
for l = 1:size(arotvert,2) %process the flat files
    try     %ditto on top, not elegant...I know
        rotvert_tmp = single(dlmread([dir2,filesep,arotvert{l}],',',1,0));    %open the file
        rotvert_idx = zeros(size(rotvert_tmp,1),1);   %create the index base
        for m = 1:size(ord,1)   %go through the ordinals
            rotvert_idx(rotvert_tmp(:,end)==ord(m,1),:) = 1;      %set to keep
        end
        rotvert_tmp = rotvert_tmp(logical(rotvert_idx),:);     %the few, the proud, the selected
        sav2csv(rotvert_tmp,arotvert{l}(1:end-4),dirsav);    %save out
    catch
        warning([dirsav,filesep,'3D']);
    end
end
%now do the rotated termini
rotterm_tmp = single(dlmread([dir2,filesep,'arotated_termini.csv'],',',1,0));    %open
try     %this is a hack, in the python version we got to streamline the rotation aspect of this.
    rotterm = rotterm_tmp(idx,:);   %select
    %comment out above if you want to actually use the ordinals, next
    %analysis I guess
%     rotterm_idx = zeros(size(rotterm_tmp,1),1);   %create the index base
%     for n = 1:size(ord,1)   %go through the ordinals
%         rotterm_idx(rotterm_tmp(:,end)==ord(n,1),:) = 1;      %set to keep
%     end
%     rotterm = rotterm_tmp(logical(rotterm_idx),:);     %the few, the proud, the selected
    sav2csv(rotterm,'arotated_termini.csv',dirsav);    %save
catch
    warning([dirsav,filesep,'arotated_termini.csv']);
end     %if didn't work, means the rotated termini was not the same size, just skip it, because not important at this point.

%save out summary data files
%count data
data_tmp = dataset(acount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary.csv',dirsav);
data_tmp = dataset(aucount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary.csv',dirsav);


%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [idx,dir2,dirsav,ord] = parse(input)

dist = 1;    
idx = [];
dir1 = [];
dir2 = [];
dir3 = [];
dirsav = [];
file1 = [];
file2 = [];
file3 = [];
sub_vert = [];
prepost = [];    %off
ord = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dist'
                    dist = input{1,i+1};
                case 'index'
                    idx = input{1,i+1};
                case 'dir1'
                    dir1 = input{1,i+1};
                case 'file1'
                    file1 = input{1,i+1};
                case 'dir2'
                    dir2 = input{1,i+1};
                case 'file2'
                    file2 = input{1,i+1};
                case 'dir3'
                    dir3 = input{1,i+1};
                case 'file3'
                    file3 = input{1,i+1};
                case 'dirsav'
                    dirsav = input{1,i+1};
                case 'vert'
                    sub_vert = input{1,i+1};
                case 'prepost'
                    prepost = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

if ~isempty(prepost)   %turn on prepost
    %generate the filename for the vertices file
    if isempty(dir1)||isempty(file1)    %no directory or vertices file entered
        [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
            'Open verticies file that define the subclass','Multiselect','off');
    end
    if isempty(dir2)||isempty(file2)    %no directory or vertices file entered
        [file2,dir2,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
            'Open origin verticies file','Multiselect','off');
    end
    if isempty(dir3)||isempty(file3)    %no directory or vertices file entered
        [file3,dir3,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
            'Open termini verticies file','Multiselect','off');
    end
    %call sysubidx
    [idx,dir2,ord] = synsubidx('dist',dist,'prepost',prepost,'dir1',dir1,'file1',file1,'dir2',dir2,'file2',file2,...
        'dir3',dir3,'file3',file3,'propstr','aprop');
else
    if ~isempty(sub_vert)   %vert mode
        if size(sub_vert,2)<3   %not in the correct format
            [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                'Open subvertices file','Multiselect','off');      %open up the first vertices file, which is the subset
            sub_vert = single(dlmread([dir1,file1],',',1,0));    %open the file
        else
            sub_vert = sub_vert(:,1:3);     %just first three columns
        end
        %now open the full vertices file, this is comparision file
        [file2,dir2,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
            'Open full vertices file','Multiselect','off');
        ful_vert = single(dlmread([dir2,file2],',',1,0));    %open the file
        ful_vert = ful_vert(:,1:3);     %just the first three columns
        %now find the correspondences
        [a2b,b2a,ab,idx] = unique_verts2(sub_vert,ful_vert);
        idx = idx{4};
        ord = ful_vert(idx,end);
    elseif isempty(idx)     %no index was entered
        if isempty(dir1)||isempty(file1)    %no directory or vertices file entered
            [file1,dir1,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
                'Open properties file that will define the subclass','Multiselect','off');
        end
        %now create the index
        idxprop = single(dlmread([dir1,file1],',',1,0));    %open the file
        idx = idxprop(:,end)<=dist;      %create the index variable, the last column is always the distance from origin
    end
    
    %now check if dir2 and 3 are entered
    if isempty(dir2) && isempty(sub_vert)   %vert mode will generate it's own dir2
        dir2 = uigetdir2('','Directory of data for original class');
    end
end
if isempty(dirsav)
    dirsav = uigetdir3('','Directory to save the data of new subclass');
end

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [aprop,avert,aflat,arotvert] = process_files(dir_struct)

for i = 3:size(dir_struct,1)    %go through the 
    idx(i-2) = dir_struct(i).isdir;     %pull the isdir info
    names{i-2} = dir_struct(i).name;     %pull the file and dir names
end

%get the files
try
    list = names(~idx);
catch
    keyboard
end
%filter for only the files we want
aprop_idx = ones(size(list));   %same for prop
avert_idx = ones(size(list));   %create an index for selecting the flat files
aflat_idx = ones(size(list));
arotvert_idx = ones(size(list));
for j = 1:size(list,2);
    stridx = isstrprop(list{j},'punct');
    stridx = find(stridx==1);   %the second '_' is the one
    %the only files we care about are the flat rotated vertices and the properties for now
    if ~strcmp('aprop',list{j}(1:stridx(1)-1))
        aprop_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('avert',list{j}(1:stridx(1)-1))
        avert_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('aflat',list{j}(1:stridx(1)-1))
        aflat_idx(j) = 0;    %set this for removal
    end
    if ~strcmp('a3Dvert',list{j}(1:stridx(1)-1))
        arotvert_idx(j) = 0;    %set this for removal
    end
end
%create the desired lists of file names.
aprop = list(logical(aprop_idx));    %list for prop filesflat = list(logical(flat_idx));    %list for flat vertices files
avert = list(logical(avert_idx));    %list for flat vertices files
aflat = list(logical(aflat_idx));
arotvert = list(logical(arotvert_idx));